# 删除有序数组中的重复项 II

<p>给你一个有序数组 <code>nums</code> ，请你<strong><a href="http://baike.baidu.com/item/%E5%8E%9F%E5%9C%B0%E7%AE%97%E6%B3%95"
            target="_blank"> 原地</a></strong> 删除重复出现的元素，使每个元素 <strong>最多出现两次</strong> ，返回删除后数组的新长度。</p>
<p>不要使用额外的数组空间，你必须在 <strong><a href="https://baike.baidu.com/item/%E5%8E%9F%E5%9C%B0%E7%AE%97%E6%B3%95"
            target="_blank">原地 </a>修改输入数组 </strong>并在使用 O(1) 额外空间的条件下完成。</p>
<p> </p>
<p><strong>说明：</strong></p>
<p>为什么返回数值是整数，但输出的答案是数组呢？</p>
<p>请注意，输入数组是以<strong>「引用」</strong>方式传递的，这意味着在函数里修改输入数组对于调用者是可见的。</p>
<p>你可以想象内部操作如下:</p>
<pre>
    // <strong>nums</strong> 是以“引用”方式传递的。也就是说，不对实参做任何拷贝
    int len = removeDuplicates(nums);// 在函数里修改输入数组对于调用者是可见的。
    // 根据你的函数返回的长度, 它会打印出数组中<strong> 该长度范围内</strong> 的所有元素。
    for (int i = 0; i < len; i++) {
            print(nums[i]);
    }</pre>
<p> </p>
<p><strong>示例 1：</strong></p>
<pre><strong>输入：</strong>nums = [1,1,1,2,2,3]<strong><br />输出：</strong>5, nums = [1,1,2,2,3]<strong><br />解释：</strong>函数应返回新长度 length = <strong>5</strong>, 并且原数组的前五个元素被修改为 <strong>1, 1, 2, 2,</strong> <strong>3 </strong>。 不需要考虑数组中超出新长度后面的元素。</pre>
<p><strong>示例 2：</strong></p>
<pre><strong>输入：</strong>nums = [0,0,1,1,1,1,2,3,3]<strong><br />输出：</strong>7, nums = [0,0,1,1,2,3,3]<strong><br />解释：</strong>函数应返回新长度 length = <strong>7</strong>, 并且原数组的前五个元素被修改为 <strong>0</strong>, <strong>0</strong>, <strong>1</strong>, <strong>1</strong>, <strong>2</strong>, <strong>3</strong>, <strong>3 。</strong> 不需要考虑数组中超出新长度后面的元素。</pre>
<p> </p>
<p><strong>提示：</strong></p>
<ul>
    <li><code>1 <= nums.length <= 3 * 10<sup>4</sup></code></li>
    <li><code>-10<sup>4</sup> <= nums[i] <= 10<sup>4</sup></code></li>
    <li><code>nums</code> 已按升序排列</li>
</ul>
<p>以下错误的选项是？</p>

## aop

### before

```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after

```cpp
int main()
{
    Solution sol;
    vector<int> nums = {1, 1, 1, 2, 2, 3};

    int res;
    res = sol.removeDuplicates(nums);
    cout << res << endl;
    for (auto i : nums)
        cout << i << " ";
    return 0;
}
```

## 答案

```cpp
class Solution
{
public:
    int removeDuplicates(vector<int> &nums)
    {
        int n = nums.size();
        if (n <= 2)
        {
            return n;
        }
        int sp = 1;
        for (int fp = 2; fp < n; fp++)
        {
            if (nums[fp] != nums[sp - 1])
            {
                nums[++sp] = nums[fp];
            }
        }
        return sp;
    }
};
```

## 选项


### A

```cpp
class Solution
{
public:
    int removeDuplicates(vector<int> &nums)
    {
        unordered_map<int, int> maps;
        int n = 0;
        for (int i = 0; i < nums.size(); ++i)
        {
            if (maps[nums[i]] < 2)
            {
                maps[nums[i]]++;
                n++;
            }
            else
            {
                nums.erase(nums.begin() + i);
                --i;
            }
        }
        return n;
    }
};
```

### B

```cpp
class Solution
{
public:
    int removeDuplicates(vector<int> &nums)
    {
        if (nums.empty())
            return 0;
        int len;
        len = 1;
        for (int i = 1; i < nums.size(); i++)
        {
            if (i == 1 || nums[i] != nums[len - 2])
            {
                nums[len] = nums[i];
                ++len;
            }
        }
        return len;
    }
};
```

### C

```cpp
class Solution
{
public:
    int removeDuplicates(vector<int> &nums)
    {

        int ret = nums.size(), quantity = nums[0], num = 0;

        for (vector<int>::iterator iter = nums.begin(); iter != nums.end(); iter++)
        {

            if (*iter == quantity)
            {
                num++;

                if (num > 2)
                {
                    iter = nums.erase(iter);
                    iter--;
                    ret--;
                    num = 2;
                }
            }

            else
            {
                quantity = *iter;
                num = 1;
            }
        }
        return ret;
    }
};
```
